import { uploadImage } from '@/api/uploadImage';
// import { getVideoCover } from '@/utils/getVideoCover';
import React, { useState } from 'react';

export const useSelectMultipleFile = () => {
  const [images, setImages] = useState<string[]>([]);
  const [uploaded, setUploaded] = useState<any[]>([]);
  const [load, setload] = useState<boolean>(false);
  const [text, setText] = useState<any[]>([]);
  const [posiion, setPosition] = useState<any[]>([]);
  const [linkedin, setLinkedin] = useState<any[]>([]);
  const [about, setAbout] = useState<any[]>([]);
  const [file, setFile] = useState<File | null>(null);

  // const [cover, setCover] = useState<string>();
  // const [pdfName, setpdfName] = useState<string>();

  const handleChange = async (e: React.ChangeEvent<HTMLInputElement>) => {
    const previews = [];
    const texts = text;
    const positions = position;
    const linkedins = linkedin;
    const abouts = about;
    const uploads = uploaded;
    const files = e?.target?.files ?? [];

    for (const file of files) {
      if (file) {
        setload(true);
        const preview = URL.createObjectURL(file);
        previews.push(preview);
        texts.push('');
        abouts.push('');
        positions.push('');
        linkedins.push('');

        const res = await uploadImage({ file });
        uploads.push(res.url);
        setload(false);

        // if (isVideo(file.name)) {
        //   const cov = await getVideoCover(file, 1.5);
        //   setCover(cov);
        // }
        // if (isPdf(file.name)) {
        //   const pdfName = file.name;
        //   setpdfName(pdfName);
        // }
      }
    }
    setUploaded(uploads);
    setload(load);
    setText(texts);
    setPosition(positions);
    setLinkedin(linkedins);
    setImages(images.concat(previews));
  };

  const deleteImage = (val: number) => {
    const filteredItems = images.filter((i, index) => index !== val);
    const uploadsItems = uploaded.filter((i, index) => index !== val);
    const filteredNames = text.filter((i, index) => index !== val);
    const filteredAbouts = about.filter((i, index) => index !== val);
    const filteredPositions = about.filter((i, index) => index !== val);
    const filteredLinkedins = about.filter((i, index) => index !== val);
    setText(filteredNames);
    setAbout(filteredAbouts);
    setImages(filteredItems);
    setUploaded(uploadsItems);
    setPosition(filteredPositions);
    setLinkedin(filteredLinkedins);
  };

  return {
    file,
    images,
    load,
    handleChange,
    setImages,
    setFile,
    uploaded,
    deleteImage,
    text,
    about,
    setAbout,
    setText,
    setPosition,
    setLinkedin,
  };
};

export function getExtension(filename: string) {
  const parts = filename.split('.');
  return parts[parts.length - 1];
}

export function isImage(filename: string) {
  const ext = getExtension(filename);
  switch (ext.toLowerCase()) {
    case 'jpg':
    case 'gif':
    case 'bmp':
    case 'png':
      //etc
      return true;
  }
  return false;
}

export function isVideo(filename: string) {
  const ext = getExtension(filename);
  switch (ext.toLowerCase()) {
    case 'm4v':
    case 'avi':
    case 'mpg':
    case 'mp4':
      // etc
      return true;
  }
  return false;
}

export function isPdf(filename: string) {
  const ext = getExtension(filename);
  switch (ext.toLowerCase()) {
    case 'pdf':
      //etc
      return true;
  }
  return false;
}
